#ifndef DEBUGMODEVALUE_H
#define DEBUGMODEVALUE_H

#include <QtGui>

class QComboBox;
class QLineEdit;
class QPushButton;
class QGroupBox;
class QLabel;
class ComboBox;
class QGridLayout;
class QGroupbox;
class QListWidget;

typedef struct _item{
	QString name;
	int index;
} Item;

class DebugModeValue : public QDialog
{
	Q_OBJECT
		
public:
	DebugModeValue(QWidget*);
	virtual ~DebugModeValue();
	QString returnValue;
	QList <Item*> items;
	void CreateValueInput();
		
public slots:
	void OkButtonPress();
	void Close();
	void Slot_Value();
	void Slot_Value_Return();
	void Slot_ValueChange(QListWidgetItem* currentItem, QListWidgetItem* previousItem);
		
private:
	
	QGroupBox* parameterGroup;
	QGroupBox* inputGroup;
	QGroupBox* buttonGroup;
	
	QListWidget* parameterValue;

	QLineEdit* inputLineEdit;
	
	
	QPushButton* okbutton; 
	QPushButton* cancelbutton;
	
	QLabel* inputLabel;
	QLabel* inputLabel2;
	
	QComboBox* inputComboBox;

	QGridLayout *parameterLayout;
	QGridLayout *inputLayout;
	QGridLayout *buttonLayout;
	QGridLayout *layout;	
};

#endif
